@echo off
title Dead Island 2 GPU Fix (Enhanced)
echo ============================================
echo Dead Island 2 GPU Fix Script (Enhanced)
echo ============================================
echo.
echo This script forces Dead Island 2 to use a specific GPU.
echo Default is 0 (try this first).
echo If that doesn't work, rerun and choose 1, 2, 3, etc.
echo.

setlocal
set "configPath=%USERPROFILE%\AppData\Local\DeadIsland\Saved\Config\WindowsNoEditor\Engine.ini"

:: Check if file exists
if not exist "%configPath%" (
    echo Config file not found: %configPath%
    echo Please start Dead Island 2 once so the file is created.
    pause
    exit /b
)

:: Backup before editing
copy "%configPath%" "%configPath%.bak" >nul
echo Backup created: Engine.ini.bak
echo.

:: Show current value if it exists
echo Checking current GPU setting...
for /f "tokens=*" %%A in ('findstr /C:"r.GraphicsAdapter=" "%configPath%"') do (
    echo Current setting: %%A
)
echo.

:menu
echo Choose which GPU adapter to force:
echo   0 - Default (try this first)
echo   1 - Alternate GPU
echo   2 - Third GPU
echo   3 - Fourth GPU
echo.
set /p choice=Enter GPU adapter index (default 0): 

if "%choice%"=="" set choice=0

echo.
echo Applying GPU fix with r.GraphicsAdapter=%choice% ...

:: Use PowerShell to update or insert the setting
powershell -Command ^
    "$file = '%configPath%';" ^
    "$content = Get-Content $file;" ^
    "if ($content -match 'r.GraphicsAdapter=') {" ^
    "    $content = $content -replace 'r.GraphicsAdapter=\d+', 'r.GraphicsAdapter=%choice%';" ^
    "} elseif ($content -match '\[/script/engine.renderersettings]') {" ^
    "    $content = $content -replace '(\[/script/engine.renderersettings])', '$1`r`n r.GraphicsAdapter=%choice%';" ^
    "} else {" ^
    "    $content += '[/script/engine.renderersettings]';" ^
    "    $content += 'r.GraphicsAdapter=%choice%';" ^
    "}" ^
    "Set-Content $file -Value $content"

echo.
echo Done! Engine.ini has been updated with:
echo r.GraphicsAdapter=%choice%
echo.
echo Now start Dead Island 2 and check if it uses the correct GPU.
echo ============================================
pause